#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <pthread.h>
#include <time.h>
#include <inttypes.h>
/*Para compilar usar:
		gcc -o prime69 main.c -lm -lpthread
*/
#ifdef _WIN32
   #ifdef _WIN64
      #define os 11 //win 64
   #else
      #define os 10 //win 32
      #error "Incompatible with win 32"
   #endif
#elif __linux__
    #define os 20 //linux
#else
#   error "Unknown compiler"
#endif

unsigned long long stoi(char *str);
int strleng(char *str);
int timeval_subtract(struct timeval *result, struct timespec *t2, struct timespec *t1);

struct threaddata {
	long long threadstart;
	long long threadend;
	int threadnum;
};

void *primesearch(struct threaddata *ranges){
	
	register unsigned long long int threadsize = ranges->threadend;
	register unsigned long long int i = ranges->threadstart;
	int threadnum = ranges->threadnum;
	register unsigned long long int j;
	register int pol;
	register unsigned long long int count = 0;
	if(i < 2){
		i = 2;
	}
	
	printf("\nThread %d para procurar numeros primos num espaco de %llu a %llu...",threadnum,i,threadsize);
	
	//loop principal
	for (; i < threadsize; i++){
    	pol = 0;
    	for(j=2 ; j<=sqrt(i) ; j++){
    		if(i%j == 0)
    			pol = 1;
		}
		if (!pol)
	 		count++;
	}
	
	printf("\nPrimos contados pelo thread %d: %llu",threadnum, count);

	pthread_exit((void *)count);
}


///main 
int main(int argc, char *argv[]) {
		
	clock_t TVBegin, TVEnd;
	double TVDif = 0.0;
	unsigned long long int totalprimecount = 0;
	unsigned long long int size = 1000;
	unsigned long long int threadsize = 250;
	
	int threadcount = 1;
	
	int i; // proposito geral
	
	char *title;
	char *intro;
	
	title = "\n\t\t\u2591PRIME 69\u2591\n";
	intro = "\n   \u2591O contador de numeros primos do iug.\u2591\n";

	printf("\n\t\t");
	for(i=4;i<strleng(title)-4;i++)
		printf("\u2591");
		
	printf("%s",(char *)title);
	
	printf("   ");
	for(i=5;i<strleng(intro)-4;i++)
		printf("\u2591");
	
	printf("%s",(char *)intro);
	
	printf("   ");
	for(i=5;i<strleng(intro)-4;i++)
		printf("\u2591");
	printf("\n");
	
	i=0;
	
	//parse a um posivel codigo de ajuda bo primeiro argumnto
	if(argc == 2){
		if(*argv[1] == 'h'){
			printf("\n\t\t  HELP:\n\n");
			printf("O prime69 \u00E9 um programa que verifica quantos numeros primos existem na gama que lhe \u00E9 dada.\nEsta gama de numeros come\u00C7a sempre no numero 2 e acaba no valor que lhe \u00E9 dado no primeiro argumento.\n\n");
			printf("Este programa est\u00E1 optimizado para processadores multicore com a utiliza\u00C7\u00E3o de threads.\nO numero de threads \u00E9 especificado com segundo argumento.\n");
			printf("Quando o segundo argumento \u00E9 omitido apenas um thread \u00E9 criado.\nCaso exista mais que um thread a gama \u00E9 dividida entre eles.\n\n");
			printf("A estrutura do comando \u00E9 a seguinte:\n:: prime69 1000 4\n\t[tamanho da gama] [n\u00BA de threads]\n\n");
			printf("Para a maxima percis\u00E3o use apenas um thread para contar.\nDesvios podem acontecer devido a forma que a gama \u00E9 definida dinamicamente no runtime do programa.\n");
			return 0;
		}
	}
	
	//parse aos argumentos
	if(argc<=1){
		printf("Necessita de especificar o tamanho da busca.\nUse h no primeiro argumento para ajuda.\n:: prime69 h\n");
		return 12;
	}else if(stoi(argv[1])){
		size = stoi(argv[1]);
		printf("Tamanho dado = %llu", size);
		if(size < 100){
			printf("\nO tamanho da busca tem que ser maior que 100 (1000 predefinido)\n");
			return 10;
		}
	}else{
		printf("\nNumero invalido.\n");
		return 11;
	}
	
	//parse aos threads
	if(argc==3){
		threadcount = stoi(argv[2]);
		if(threadcount > 32){
			printf("\nO numero maximo de threads \u00E9 32.");
			return 15;
		}else if(threadcount < 1){
			printf("\nSem thread nenhum n\u00E3o vai dar para contar muitos primos.\nUse pelo menos 1 thread.");
			return 14;
		}else{
			printf("\nNumero de threads: %d",threadcount);
		}
	}else{
		printf("\nValor de threads omitido a spawnar 1.");
		threadcount = 1;
	}
	
	unsigned long long int start,end; // para defenir as areas de cada thread
	pthread_t threadid[threadcount]; // um id para cada thread;
	unsigned long long int threadprimecount[threadcount]; // vai ser usado para guardar o valor de return dos threads em join
	void *threadreturnval[threadcount];
	struct threaddata ranges[threadcount];
	
	threadsize = size / threadcount;
	start = 0;
	end = threadsize;

	TVBegin = clock(); // timestamp inicial 
	
	for(i = 0; i < threadcount; i++){
		ranges[i].threadstart = start; 
		ranges[i].threadend = end;
		ranges[i].threadnum = i;
		start = end + 1;
		end+=threadsize;
	}
	
	for(i = 0; i < threadcount; i++)
		pthread_create(&threadid[i], NULL,(void *)primesearch, &ranges[i]); //spawnar threads em primesearch
	
	for(i = 0; i < threadcount; i++){
		pthread_join(threadid[i],&threadreturnval[i]); // isto vai esperar pela concluo dos threads
		threadprimecount[i] = (long long)threadreturnval[i];
		printf("\nO thread %d terminou com o numero de primos contados em: %llu",i,threadprimecount[i]);
	}
	
	for(i = 0; i < threadcount; i++){
		totalprimecount += threadprimecount[i];
	}
	
	printf("\nA contagem total \u00E9: %llu\n", totalprimecount);
	
	TVEnd = clock(); // timestamp final				// passa-se alguma coisa 
    	TVDif = (double)(TVEnd - TVBegin) / (CLOCKS_PER_SEC * 4);	// com esta função quando se usa 
    	printf("Tempo da contagem: %f Segundos\n", TVDif);		// todos os CPUs
	
	if(threadcount > 1){
		printf("A contagem total pode estar desviada em %d ou -%d devido a ter sido usado mais que um thread.\n",threadcount,threadcount);
	}
	
	return 0;
}

unsigned long long stoi(char *str){
	unsigned long long num = 0;
		
		while(*str >='0' && *str <= '9'){
			num = num * 10 + *str++ -'0';
		}

	return num;	
}

int strleng(char *str) {
	int count = 0;
	
	while(*str++ != '\0')
		count++;
		
	return count;
}

/* O linux gosta de numeros unicode no terminal
 *	\uXXXX
 * 	\u seguido do numero unicode
 *	\u2593 para o block de shade mais escura
 *
 * ideia para distribuir o tamanho pelos threads
 * 	tamanho do thread == tamanho total / n threads
*/
